/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.sct.gui.activityarea;

import com.quantumdata.sct.comm.TEInterface;
import com.quantumdata.sct.gui.ComplianceTesterToolUI;
import com.quantumdata.sct.gui.activityarea.ActivityArea;
import com.quantumdata.sct.gui.activityfolder.EDIDDeclareFolder;
import com.quantumdata.sct.gui.activityfolder.EDIDResultFolder;
import com.quantumdata.sct.gui.activityfolder.HDCPDeclareFolder;
import com.quantumdata.sct.gui.activityfolder.HDCPResultFolder;
import com.quantumdata.sct.gui.activityfolder.ToolsDeclareFolder;
import com.quantumdata.sct.gui.activityfolder.ToolsResultFolder;
import com.quantumdata.sct.gui.activityfolder.ToolsTestFolder;
import com.quantumdata.sct.util.SCTSelection;

public class ToolsActivityArea
extends ActivityArea {
    private ToolsDeclareFolder m_declareFolder;
    private ToolsTestFolder m_testFolder;
    private ToolsResultFolder m_resultFolder;
    private EDIDDeclareFolder m_edidDeclareFolder;
    private EDIDResultFolder m_edidResultFolder;
    private EDIDResultFolder m_edidDataFolder;
    private HDCPDeclareFolder m_hdcpDeclareFolder;
    private HDCPResultFolder m_hdcpResultFolder;

    public ToolsActivityArea(ComplianceTesterToolUI complianceTesterToolUI) {
        super(complianceTesterToolUI, "Tools");
    }

    public void initialize(ComplianceTesterToolUI complianceTesterToolUI) {
        this.m_testFolder = new ToolsTestFolder(complianceTesterToolUI);
        this.m_resultFolder = new ToolsResultFolder(complianceTesterToolUI);
        this.addActivityFolder(this.m_testFolder);
        this.addActivityFolder(this.m_resultFolder);
        this.setSelectedIndex(1);
    }

    public void addCDFOnly(ComplianceTesterToolUI complianceTesterToolUI) {
        this.m_declareFolder = new ToolsDeclareFolder(complianceTesterToolUI);
        this.addActivityFolder(this.m_declareFolder);
    }

    public void addEDIDFolders(ComplianceTesterToolUI complianceTesterToolUI) {
        this.m_edidResultFolder = new EDIDResultFolder(complianceTesterToolUI, "Compliance Report");
        this.m_edidDataFolder = new EDIDResultFolder(complianceTesterToolUI, "Data Report");
        this.m_edidDeclareFolder = new EDIDDeclareFolder(complianceTesterToolUI, this.m_edidResultFolder, this.m_edidDataFolder);
        this.addActivityFolder(this.m_edidDeclareFolder);
        this.addActivityFolder(this.m_edidResultFolder);
        this.addActivityFolder(this.m_edidDataFolder);
    }

    public void addHDCPFolders(ComplianceTesterToolUI complianceTesterToolUI) {
        this.m_hdcpResultFolder = new HDCPResultFolder(complianceTesterToolUI, "Compliance Report");
        this.m_hdcpDeclareFolder = new HDCPDeclareFolder(complianceTesterToolUI, this.m_hdcpResultFolder);
        this.addActivityFolder(this.m_hdcpDeclareFolder);
        this.addActivityFolder(this.m_hdcpResultFolder);
    }

    public void setHdcpProductName(String string) {
        this.m_hdcpDeclareFolder.setProductName(string);
    }

    public void setEdidProductName(String string) {
    }

    public boolean setUUT() {
        if (SCTSelection.instance().getCurrentConnection() == null) {
            return false;
        }
        TEInterface tEInterface = TEInterface.instance();
        if (tEInterface.m_instrument == null) {
            return false;
        }
        if (!tEInterface.m_instrument.isConnected()) {
            return false;
        }
        String string = SCTSelection.instance().getUutType();
        System.out.println(string);
        try {
            tEInterface.setQuery("UUTL " + string);
            tEInterface.sendCommand(true);
            tEInterface.setQuery("UUTU");
            tEInterface.sendCommand(true);
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
        return true;
    }
}

